<?php
/**
 * Error Logger Function
 */
function wst_links_log($var, $title,$file ='errors')
{
  $varr = print_r($var, true);
  error_log('##' . $title . ': ' . $varr . ' ##' . PHP_EOL, 3, get_stylesheet_directory() . '/log/'.$file.'.txt');
  return;
};

// Help when working with APIs
function wstCallAPI($method, $url, $data)
{
  $curl = curl_init();

  switch ($method) {
    case "POST":
      curl_setopt($curl, CURLOPT_POST, 1);
      if ($data)
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
      break;
    case "PUT":
      curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
      if ($data)
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
      break;
    default:
      if ($data)
        $url = sprintf("%s?%s", $url, http_build_query($data));
  }

  // OPTIONS:
  curl_setopt($curl, CURLOPT_URL, $url);
  curl_setopt($curl, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'key: Content-Type',
    'name: Content-Type',
    'value: application/json',
    'type: text'
  ));
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

  // EXECUTE:
  $result = curl_exec($curl);

  // ERROR HANDELING:
  if($result === false)
  {
    wst_links_log(curl_error($curl), '///////////////// cURL Error //////////////','footer-links-cron');
  }

  curl_close($curl);

  $curl_info = curl_getinfo($curl); 
  if($curl_info['http_code'] != 200)
  {
    wst_links_log($curl_info, '///////////////// cURL Info API CALL HTTP Code is not 200 //////////////','footer-links-cron');
  }

  return $result;
}

/**
 * Company Footer link shortcode
 */
function wst_company_footer_links_shortcode() 
{
  return wst_company_footer_links_func();
}
add_shortcode('wst_company_footer_links', 'wst_company_footer_links_shortcode');

function wst_company_footer_links_func()
{
  $link = get_field('company_links','option');
  return $link;
};

/**
 * API call to webservice.team to get the company links and update the filed in the backend
 * this function is ran by the cron
 */
function get_wst_company_footer_links()
{
  $company = get_field('company_brand','option');
  
  if (is_null(get_field('company_brand','option')) || get_field('company_brand','option') === 'non') 
    return;
  $currentDateTime = new DateTimeImmutable('now');
  $curlURL = 'https://webservice.team/wp-json/wp/v2/company_links?_fields=acf';
  $request = wstCallAPI('GET',$curlURL,false);
	
  if($request === false)
  {
    wst_links_log($request, '## cURL Error '.$currentDateTime->format('m/d/Y, g:i a'),'footer-links-cron');
    return;
  }

  
  $companies = json_decode($request);
  foreach ($companies as $c) 
  {
    if($company == $c->acf->company_brand){
      update_field('company_links',$c->acf->footer_links,'option');
      wst_links_log($currentDateTime->format('m/d/Y, g:i a'), '## Updated Footer Links ','footer-links-cron');
    }
  }
  
  return;
};
